function dC = Pollution_model(t,C)

%1.  RNO = + r1 - r3 - r6 = + k1[NO][CO] - k3[O3][NO] - k6[NO][HO2]
%2.  RNO2 = - r1 + r3 + r6 - r7 = - k1[NO2] + k3[NO2][O2] + k6[NO2][OH] - k7[NO2][OH]
%3.  RO = + r1 - r2 = + k1[NO][O] - k2[O][O2][M]
%4.  RO3 = + r2 - r3 = + k2[O3][NO]
%5.  RHO2 = + r4a - r5 - r6 = + 2 k4a[HO2]^2 - k5[HO2][CO][H2O] - k6[HO2][NO]
%6.  RH2 = + r4b = + k4b[H2][CO]
%7.  RHNO3 = + r7 = + k7[HNO3]
%8.  RH2O = + r5 = + k5[HO2][CO][H2O]
%9.  RHCHO = - r4a - r4b - r5 = - k4a[HO2]^2[CO] - k4b[HCHO] - k5[OH][NO2]
%10. RCO = - r4a - r4b + r5 = - k4a[HCOH][OH] - k4b[H2][CO] + k5[HO2][CO][H2O]
%11. ROH = - r5 + r6 - r7 = - k5[HCOH][OH] + k6[NO2][OH] - k7[OH][NO2]

% NO   --> dC(1); C(1)
% NO2  --> dC(2); C(2)
% O    --> dC(3); C(3)
% O3   --> dC(4); C(4)
% HO2  --> dC(5); C(5)
% H2   --> dC(6); C(6)
% HNO3 --> dC(7); C(7)
% H2O  --> dC(8); C(8)
% CHOH --> dC(9); C(9)
% CO   --> dC(10); C(10)
% OH   --> dC(11); C(11)
% O2   --> dC(12); C(12)
% M    --> dC(13); C(13)

dC = zeros(13,1);

global m
%m.k    Constantes cintiques

%Calcul des vitesses de ractions



r1 = m.k1* C(2);
r2 = m.k2 * C(3);
r3 = m.k3*C(4) * C(1);
r4a = m.k4a* C(9);
r4b = m.k4b* C(9);
r5 = m.k5 * C(9) * C(11);
r6 = m.k6 * C(5) * C(1);
r7 = m.k7 * C(11) * C(2);

%quations diffrentielles

dC(1)  = + r1 - r3 - r6;
dC(2)  = - r1 + r3 + r6 - r7; 
dC(3)  = + r1 - r2;
dC(4)  = + r2 - r3;
dC(5)  = + 2*r4a + r5 - r6;
dC(6)  = + r4b;
dC(7)  = + r7;
dC(8)  = + r5;
dC(9)  = - r4a - r4b - r5;
dC(10) = + r4b + r4a + r5;
dC(11) = - r5 + r6 - r7;
dC(12) = 0;
dC(13) = 0;

end
